'use strict';

/* --------------------------------------------------------------
 extend_tracking_codes_button.js 2017-11-02
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2017 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Extends the order status modal with a "notify-klarna" checkbox.
 *
 * Notice: This method will use jQuery UI modal for the prompt.
 */
(function () {
	'use strict';

	/**
  * Initializes the module.
  *
  * @private
  */

	var init = function init() {
		// Tracking code selectors.
		var $trackingCodeText = void 0;
		var $shippingCompanySelect = void 0;

		// Create prompt dialog (will be initially hidden).
		var $dialog = $('<div/>', {
			'class': 'klarna-hub dialog shipment-tracking hidden',
			'html': [$('<p/>', {
				'text': KlarnaHub.Config.lang.TRANSMIT_SHIPMENT_NUMBER_TO_KLARNA
			})]
		});

		// Bind button click event handler.
		var bindTrackingCodesButtonEvent = function bindTrackingCodesButtonEvent() {
			$shippingCompanySelect = $('#parcel_services_dropdown');
			$trackingCodeText = $('#parcel_service_tracking_code');

			var $addTrackingCodeButton = $('span.add_tracking_code');

			$addTrackingCodeButton.on('click', function () {
				if ($shippingCompanySelect.val() === '') {
					return;
				}

				if ($trackingCodeText.val() === '') {
					return;
				}

				$dialog.dialog('open');
			});
		};

		var buttons = [{
			text: KlarnaHub.Config.lang.NO,
			click: function click() {
				return $dialog.dialog('close');
			}
		}, {
			text: KlarnaHub.Config.lang.NOTIFY_KLARNA,
			click: function click() {
				var shippingCompany = $shippingCompanySelect.find('option:selected').text();
				var trackingNumber = $trackingCodeText.val();

				KlarnaHub.Api.executeAddTrackingCode(shippingCompany, trackingNumber).then(function () {
					return location.reload();
				});
			}
		}];

		$dialog.dialog({
			autoOpen: false,
			width: 500,
			height: 'auto',
			resizable: false,
			modal: true,
			title: KlarnaHub.Config.lang.SHIPMENT_TRACKING,
			dialogClass: 'gx-container',
			close: bindTrackingCodesButtonEvent,
			buttons: buttons
		});

		$dialog.parent().find('.ui-dialog-buttonpane button:last-child').addClass('btn-primary');

		bindTrackingCodesButtonEvent();
	};

	KlarnaHub.on('ready', function () {
		return init();
	});
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
